#include <iostream>
#include <functional>
#include <algorithm>
#include <cmath>
#include <map>
#include <vector>

using namespace std;

int **read(int n, int m) {
    int **t = new int *[n];
    for (int i = 0; i < n; i++) {
        t[i] = new int[m];
        for (int j = 0; j < m; j++)
            scanf("%d", t[i] + j);
    }
    return t;
}

bool comp(pair<int, int> a, pair<int, int> b) {
    if (a.first < b.first)
        return true;
    if (a.first > b.first)
        return false;
    return a.second < b.second;
}

void sort(int p, int q, int **t, pair<int, int> *x) {
    int i = p;
    int j = q;
    pair<int, int> r = x[(p + q) / 2];
    int rt = t[r.first][r.second];
    while (i <= j) {
        for (; t[x[i].first][x[i].second] < rt || (t[x[i].first][x[i].second] == rt && comp(x[i], r)); i++);
        for (; t[x[j].first][x[j].second] > rt || (t[x[j].first][x[j].second] == rt && comp(r, x[j])); j--);
        if (i <= j) {
            swap(x[i], x[j]);
            i++;
            j--;
        }
    }
    //cout << i << ' ' << j << endl;
    if (i < q)
        sort(i, q, t, x);
    if (p < j)
        sort(p, j, t, x);
}

pair<int, int> *form(int n, int m, int **t) {
    auto x = new pair<int, int>[n * m];
    for (int i = 0; i < n * m; i++)
        x[i] = make_pair(i / m, i % m);

    //auto temp = new int[n * m];

    /*for (int i = 0; i < n * m; i++)
        temp[i] = i;*/

    /*function<void(int, int)> sort = [&x, &t, &sort](int p, int q) -> void {
        int i = p;
        int j = q;
        pair<int, int> r = x[(p + q) / 2];
        int rt = t[r.first][r.second];
        while (i <= j) {
            for (; t[x[i].first][x[i].second] < rt || (t[x[i].first][x[i].second] == rt && comp(x[i], r)); i++);
            for (; t[x[j].first][x[j].second] > rt || (t[x[j].first][x[j].second] == rt && comp(r, x[j])); j--);
            if (i <= j) {
                swap(x[i], x[j]);
                i++;
                j--;
            }
        }
        if (i < q)
            sort(i, q);
        if (p < j)
            sort(p, j);
    };
    sort(0, n * m - 1);*/
    /*sort(x, x + m * n, [&t](pair<int, int> a, pair<int, int> b)->bool{
        if(t[a.first][a.second] < t[b.first][b.second])
            return true;
        if(t[a.first][a.second] > t[b.first][b.second])
            return false;
        return comp(a, b);
    });*/
    /*sort(temp, temp + m * n, [&t, n, m](int a, int b) -> bool {
        //cout << a << ' ' << b<<endl;
        if (t[a / m][a % m] < t[b / m][b % m])
            return true;
        if (t[a / m][a % m] > t[b / m][b % m])
            return false;
        return a <= b;
    });*/
    sort(0, n * m - 1, t, x);
    /*for (int i = 0; i < n * m; i++)
        x[i] = make_pair(temp[i] / m, temp[i] % m);
    delete[] temp;*/

    /*cout << endl;
    for (int i = 0; i < n * m; i++)
        cout << x[i].first << ' ' << x[i].second << endl;*/

    return x;
}

int ****sparse_matrix(int n, int m, int **t) {
    int ****M = new int ***[n];
    for (int i = 0; i < n; i++) {
        M[i] = new int **[m];
        for (int j = 0; j < m; j++) {
            M[i][j] = new int *[(int) ceil(log2(n))];
            for (int k = 0; k < (int) ceil(log2(n)); k++)
                M[i][j][k] = new int[(int) ceil(log2(m))];
        }
    }
    for (int i = 0; (1 << i) <= n; i++)
        for (int j = 0; (1 << j) <= m; j++)
            for (int x = 0; x + (1 << i) - 1 < n; x++)
                for (int y = 0; y + (1 << j) - 1 < m; y++) {
                    if (i == 0 && j == 0)
                        M[x][y][i][j] = t[x][y]; // store x, y
                    else if (i == 0)
                        M[x][y][i][j] = min(M[x][y][i][j - 1], M[x][y + (1 << (j - 1))][i][j - 1]);
                    else if (j == 0)
                        M[x][y][i][j] = min(M[x][y][i - 1][j], M[x + (1 << (i - 1))][y][i - 1][j]);
                    else
                        M[x][y][i][j] = min(min(M[x][y][i - 1][j - 1], M[x + (1 << (i - 1))][y][i - 1][j - 1]),
                                            min(M[x][y + (1 << (j - 1))][i - 1][j - 1],
                                                M[x + (1 << (i - 1))][y + (1 << (j - 1))][i - 1][j - 1]));
                }
    return M;
}

int RMQ(int x, int y, int x1, int y1, int ****sparse) {
    if (x1 < x || y1 < y)
        return INT32_MAX;
    int k = (int) log2(x1 - x + 1);
    int l = (int) log2(y1 - y + 1);
    return min(min(sparse[x][y][k][l], sparse[x1 - (1 << k) + 1][y][k][l]),
               min(sparse[x][y1 - (1 << l) + 1][k][l], sparse[x1 - (1 << k) + 1][y1 - (1 << l) + 1][k][l]));
}

int minimum(int x, int y, int x1, int y1, int ****sparse, int n, int m) {
    int a1 = RMQ(0, 0, x - 1, y - 1, sparse);
    int a2 = RMQ(0, y1 + 1, x - 1, m - 1, sparse);
    int a3 = RMQ(x1 + 1, 0, n - 1, y - 1, sparse);
    int a4 = RMQ(x1 + 1, y1 + 1, n - 1, m - 1, sparse);
    int b1 = RMQ(0, y, x - 1, y1, sparse);
    int b2 = RMQ(x, y1 + 1, x1, m - 1, sparse);
    int b3 = RMQ(x, 0, x1, y - 1, sparse);
    int b4 = RMQ(x1 + 1, y, n - 1, y1, sparse);
    return min(min(min(a1, a2), min(a3, a4)), min(min(b1, b2), min(b3, b4)));
}

template<typename T, typename U>
int lower_bound(int l, T *sorted, U k, function<int(T, U)> comp) {
    int p = 0;
    int q = l; // Not n - 1
    while (p < q) {
        int s = p + (q - p) / 2;
        if (comp(sorted[s], k) >= 0/*k <= t[sorted[s].first][sorted[s].second]*/) {
            q = s;
        } else {
            p = s + 1;
        }
    }
    return p;
}

template<typename T, typename U>
int upper_bound(int l, T *sorted, U k, function<int(T, U)> comp) {
    int p = 0;
    int q = l; // Not n - 1
    while (p < q) {
        int s = p + (q - p) / 2;
        if (comp(sorted[s], k) <= 0/*k >= t[sorted[s].first][sorted[s].second]*/) {
            p = s + 1;
        } else {
            q = s;
        }
    }
    return p;
}

int max(vector<int> x) {
    int m = 0;
    for (int i = 1; i < x.size(); i++)
        if (x[m] < x[i])
            m = i;
    return m;
}

int main() {
    int n, m, q;
    cin >> n >> m >> q;
    int **t = read(n, m);
    pair<int, int> *sorted = form(n, m, t);
    int ****sparse = sparse_matrix(n, m, t);

    auto pairCompValue = [&t](pair<int, int> a, int b) -> int {
        if (t[a.first][a.second] > b)
            return 1;
        if (t[a.first][a.second] < b)
            return -1;
        return 0;
    };
    auto pairComp = [](pair<int, int> a, int b) -> int {
        if (a.first > b)
            return 1;
        if (a.first < b)
            return -1;
        return 0;
    };
    for (; q > 0; q--) {
        int x, y, x1, y1;
        scanf("%d%d%d%d", &x, &y, &x1, &y1);
        x--;
        y--;
        x1 += x - 1;
        y1 += y - 1;
        int p = minimum(x, y, x1, y1, sparse, n, m);
        //cout << p << endl;
        int a = lower_bound<pair<int, int>, int>(n * m, sorted, p, pairCompValue);
        int b = upper_bound<pair<int, int>, int>(n * m, sorted, p, pairCompValue);
        int a1 = lower_bound<pair<int, int>, int>(b - a, sorted + a, x, pairComp);
        int b1 = upper_bound<pair<int, int>, int>(b - a, sorted + a, x1, pairComp);
        /*cout << a << endl;
        cout << b << endl;
        cout << a1 << endl;
        cout << b1 << endl;*/
        int s = b - a - (b1 - a1);
        //cout << s << endl;
        for (int i = a + a1; i < a + b1; i++)
            if (sorted[i].second < y || sorted[i].second > y1)
                s++;
        printf("%d\n", s);
    }

    for (int i = 0; i < n; i++)
        delete[] t[i];
    delete[] t;
    delete[] sorted;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            for (int k = 0; k < (int) log2(n); k++)
                delete[] sparse[i][j][k];
            delete[] sparse[i][j];
        }
        delete[] sparse[i];
    }
    delete[] sparse;

    /*int n;
    cin >> n;
    int *t = new int[n];
    int q;
    cin >> q;
    for (int i = 0; i < n; i++)
        scanf("%d", t + i);

    map<int, vector<int>> first;
    for (int i = 0; i < n; i++)
        first[t[i]].push_back(i);

    int firstNotZero;
    for (firstNotZero = 0; firstNotZero < n && t[firstNotZero] == 0; firstNotZero++);

    for (; q > 0; q--) {
        int a;
        scanf("%d", &a);
        if (a == 0) {
            if (first[1].empty())
                printf("0 0\n");
            else
                printf("%d %d\n", first[1][0], first[1][0]);
        } else if (a == 1 || first[a].empty()) {
            if (first[0].empty())
                printf("0 0\n");
            else
                printf("%d %d\n", firstNotZero, firstNotZero);
        } else {

        }
    }

    delete[] t;*/
    return 0;
}